/*
 * Decompiled with CFR 0.152.
 */
package mcjty.rftoolsbuilder.modules.mover.client;

import com.mojang.blaze3d.vertex.PoseStack;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.function.BiFunction;
import mcjty.rftoolsbuilder.modules.mover.blocks.MoverTileEntity;
import mcjty.rftoolsbuilder.modules.mover.items.VehicleCard;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.LevelRenderer;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.block.BlockRenderDispatcher;
import net.minecraft.client.renderer.texture.OverlayTexture;
import net.minecraft.core.BlockPos;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.BlockAndTintGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.client.event.EntityViewRenderEvent;
import net.minecraftforge.client.model.data.EmptyModelData;
import net.minecraftforge.client.model.data.IModelData;
import org.jetbrains.annotations.NotNull;

public class MoverRenderer {
    private static final Map<BlockPos, Runnable> delayedPreRenders = new HashMap<BlockPos, Runnable>();
    private static final Map<BlockPos, BiFunction<Level, BlockPos, Boolean>> prerenderValidations = new HashMap<BlockPos, BiFunction<Level, BlockPos, Boolean>>();

    public static float getPartialTicks() {
        return Minecraft.m_91087_().m_91296_();
    }

    public static void actualRender(MoverTileEntity mover, @NotNull PoseStack matrixStack, Vec3 cameraPos, ItemStack card, float partialTicks, Vec3 offset) {
        matrixStack.m_85836_();
        Level level = mover.m_58904_();
        Vec3 current = mover.getLogic().getMovingPosition(partialTicks, level.m_46467_());
        matrixStack.m_85837_(current.f_82479_ - cameraPos.f_82479_ - offset.f_82479_, current.f_82480_ - cameraPos.f_82480_ - offset.f_82480_, current.f_82481_ - cameraPos.f_82481_ - offset.f_82481_);
        MultiBufferSource.BufferSource buffer = Minecraft.m_91087_().m_91269_().m_110104_();
        BlockRenderDispatcher blockRenderer = Minecraft.m_91087_().m_91289_();
        Map<BlockState, List<BlockPos>> blocks = VehicleCard.getBlocks(card, new BlockPos(1, 1, 1));
        blocks.forEach((state, positions) -> positions.forEach(pos -> {
            matrixStack.m_85836_();
            matrixStack.m_85837_((double)pos.m_123341_(), (double)pos.m_123342_(), (double)pos.m_123343_());
            BlockPos realPos = new BlockPos(current.f_82479_, current.f_82480_, current.f_82481_).m_142082_(pos.m_123341_(), pos.m_123342_(), pos.m_123343_());
            int lightColor = LevelRenderer.m_109541_((BlockAndTintGetter)level, (BlockPos)realPos);
            blockRenderer.renderSingleBlock(state, matrixStack, (MultiBufferSource)buffer, lightColor, OverlayTexture.f_118083_, (IModelData)EmptyModelData.INSTANCE);
            matrixStack.m_85849_();
        }));
        matrixStack.m_85849_();
    }

    public static void addPreRender(BlockPos pos, Runnable renderer, BiFunction<Level, BlockPos, Boolean> validator) {
        delayedPreRenders.put(pos, renderer);
        prerenderValidations.put(pos, validator);
    }

    public static void preRender() {
        HashSet todelete = new HashSet();
        delayedPreRenders.forEach((pos, consumer) -> {
            if (prerenderValidations.getOrDefault(pos, (level, blockPos) -> false).apply((Level)Minecraft.m_91087_().f_91073_, (BlockPos)pos).booleanValue()) {
                consumer.run();
            } else {
                todelete.add(pos);
            }
        });
        for (BlockPos pos2 : todelete) {
            delayedPreRenders.remove(pos2);
            prerenderValidations.remove(pos2);
        }
    }

    public static void onCameraSetup(EntityViewRenderEvent.CameraSetup event) {
        MoverRenderer.preRender();
    }
}

